<?php
// CORS 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

//  OPTIONS   CORS
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit(0);
}

//    
$action = isset($_GET['action']) ? $_GET['action'] : '';
////+  

//   
switch ($action) {
    case 'get_vehicles':
        include 'get_vehicles.php';
        break;
        
    case 'get_levels':
        include 'get_levels.php';
        break;
        
    case 'get_settings':
        include 'get_settings.php';
        break;
        
    case 'get_user_data':
        include 'get_user_data.php';
        break;
        
    default:
        //      
        http_response_code(400);
        echo json_encode(array(
            "error" => "Action parameter is required or invalid",
            "available_actions" => array(
                "get_vehicles", 
                "get_levels", 
                "get_settings", 
                "get_user_data"
            )
        ));
        break;
}